% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{b2starmix-ergmTerm}
\alias{b2starmix-ergmTerm}
\alias{InitErgmTerm.b2starmix}
\title{Mixing matrix for \eqn{k}-stars centered on the second mode of a bipartite network}
\usage{
# binary: b2starmix(k, attr, base=NULL, diff=TRUE)
}
\arguments{
\item{k}{only a single value of \eqn{k} is allowed}

\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{base}{deprecated}

\item{diff}{whether a different statistic is created for each value seen in a b1 node. When \code{diff=TRUE},
the default, a different statistic is created for each value and thus the behavior of this term is reminiscent of the
\code{nodemix} term, from which it takes its name; when \code{diff=FALSE} ,
all homophilous \eqn{k}-stars are counted together, though these \eqn{k}-stars are still
categorized according to the value of the central b1 node.}
}
\description{
This term is exactly the same as \code{b1starmix} except that the roles of
b1 and b2 are reversed.
}
\note{
The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{levels} are passed,
\code{levels} overrides \code{base}.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b2starmix", "subsection")}
}
\concept{bipartite}
\concept{categorical nodal attribute}
\concept{undirected}
