% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isid.R
\name{isid}
\alias{isid}
\title{A function to check if a set of variables form a unique ID in a dataframe.}
\usage{
isid(data, vars, verbose = FALSE)
}
\arguments{
\item{data}{A dataframe.}

\item{vars}{A character vector specifying the column names in the dataframe 
to check as unique.}

\item{verbose}{A logical, default FALSE. If TRUE, isid will tell you how many 
rows you need and how many your variables uniquely identify}
}
\value{
TRUE or FALSE. TRUE indicates the variables uniquely identify the rows. 
FALSE indicates they do not.
}
\description{
When passed a set of variable names and a dataframe, this function 
returns a check TRUE/FALSE whether or not the variables together uniquely 
identify a row in the dataframe.
}
\examples{
data(stuatt)
isid(stuatt, vars = c("sid"))
isid(stuatt, vars = c("sid", "school_year"))
isid(stuatt, vars = c("sid", "school_year"), verbose = TRUE)

}
\author{
Jared E. Knowles
}
