% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{edge_clean_cache}
\alias{edge_clean_cache}
\title{Clean up cache directory and manage storage}
\usage{
edge_clean_cache(
  cache_dir = NULL,
  max_age_days = 30,
  max_size_mb = 500,
  interactive = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{cache_dir}{Cache directory path (default: user cache directory)}

\item{max_age_days}{Maximum age of files to keep in days (default: 30)}

\item{max_size_mb}{Maximum total cache size in MB (default: 500)}

\item{interactive}{Whether to ask for user confirmation before deletion}

\item{verbose}{Whether to print detailed messages about cleaning progress}
}
\value{
Invisible list of deleted files
}
\description{
Remove outdated model files from the cache directory to comply with CRAN
policies about actively managing cached content and keeping sizes small.
}
\examples{
\donttest{
# Clean cache files older than 30 days
edge_clean_cache()

# Clean cache with custom settings
edge_clean_cache(max_age_days = 7, max_size_mb = 100)
}
}