% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{e_theme}
\alias{e_theme}
\alias{e_theme_custom}
\alias{e_theme_register}
\title{Themes}
\usage{
e_theme(
  e,
  name = c("auritus", "azul", "bee-inspired", "blue", "caravan", "carp", "chalk", "cool",
    "dark-blue", "dark-bold", "dark-digerati", "dark-fresh-cut", "dark-mushroom", "dark",
    "eduardo", "essos", "forest", "fresh-cut", "fruit", "gray", "green", "halloween",
    "helianthus", "infographic", "inspired", "jazz", "london", "macarons", "macarons2",
    "mint", "purple-passion", "red-velvet", "red", "roma", "royal", "sakura", "shine",
    "tech-blue", "vintage", "walden", "wef", "weforum", "westeros", "wonderland")
)

e_theme_custom(e, theme, name = "custom")

e_theme_register(theme, name = "custom")
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{name}{Name of theme.}

\item{theme}{Theme, A json string or a see below.}
}
\description{
Add a custom theme or apply a pre-built one.
}
\details{
The function \code{e_theme_register} can be used to register the theme globally
in R markdown or shiny (UI). This is useful because 1) the \code{e_theme_custom} registers the
theme every time and is more computationally expensive.
}
\section{Functions}{

\itemize{
 \item{\code{e_theme} - Use a default theme by name.}
 \item{\code{e_theme_custom} - Use a custom theme.}
 \item{\code{e_theme_register} - Register a theme globally in shiny or R markdown.}
}
}

\examples{
mtcars |>
  e_charts(mpg) |>
  e_line(disp) |>
  e_area(hp) |>
  e_x_axis(min = 10) -> p

p |> e_theme("chalk")
p |> e_theme_custom('{"color":["#ff715e","#ffaf51"]}')
}
\seealso{
\href{https://echarts.apache.org/en/theme-builder.html}{create your own theme}.
}
