% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebnm_methods.R
\name{confint.ebnm}
\alias{confint.ebnm}
\title{Obtain credible intervals using a fitted EBNM model}
\usage{
\method{confint}{ebnm}(object, parm, level = 0.95, nsim = 1000, ...)
}
\arguments{
\item{object}{The fitted \code{ebnm} object.}

\item{parm}{A vector of numeric indices specifying which means \eqn{\theta_i}
are to be given confidence intervals. If missing, all observations are
considered.}

\item{level}{The "confidence level" \eqn{1 - \alpha} desired.}

\item{nsim}{The number of samples to use to estimate confidence intervals.}

\item{...}{Additional arguments to be passed to the posterior sampler
function. Since \code{ebnm_horseshoe} returns an MCMC sampler, it takes
parameter \code{burn}, the number of burn-in samples to discard.  At
present, no other samplers take any additional parameters.}
}
\value{
A matrix with columns giving lower and upper confidence limits for
  each mean \eqn{\theta_i}. These will be labelled as "CI.lower" and
  "CI.upper".
}
\description{
The \code{\link[stats]{confint}} method for class \code{\link{ebnm}}.
  Estimates posterior "credible intervals" for each "true mean" \eqn{\theta_i}.
  We define the \eqn{(1 - \alpha)}\% credible interval for \eqn{\theta_i} as
  the narrowest continuous interval \eqn{[a_i, b_i]} such that
  \eqn{\theta_i \in [a_i, b_i]} with posterior probability at least
  \eqn{1 - \alpha}, where \eqn{\alpha \in (0,1)}. We estimate these credible
  intervals using Monte Carlo sampling. Note
  that by default, \code{\link{ebnm}} does not return a posterior
  sampler; one can be added to the \code{ebnm} object using function
  \code{\link{ebnm_add_sampler}}.
}
