% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_suggested.R
\name{install_suggested}
\alias{install_suggested}
\alias{show_suggested}
\alias{show_reverse_dependencies}
\title{Download all suggested packages}
\usage{
install_suggested(package = "easystats")

show_suggested(package = "easystats")

show_reverse_dependencies(package = "easystats")
}
\arguments{
\item{package}{If \code{NULL} or \code{"easystats"} (the default), all suggested
packages for all 'easystats' packages will be installed. If specific
packages are specified, only suggested packages for those packages will be
installed.}
}
\value{
Useful only for its side-effect of installing the needed packages.
}
\description{
In \code{easystats}, we have a 0-dependency policy, which makes our packages
fairly light and fast to install. However, we rely on many many (many)
packages for testing (at least all the packages for functions that we
support) and some specific features. These "soft dependencies" can be
downloaded at once using this function. This will allow you to fully utilize
all of easystats' functionalities without errors.
}
\details{
To reduce the dependency load, 'easystats' packages by default will not
download all internally needed packages. It will ask the user to download
them only if they are needed. The current function can help install all
packages a given 'easystats' package might need. For example,
\code{install_suggested("see")}. \code{show_suggested()} is a convenient helper
to show the current list of suggested packages for each 'easystats'
package.
}
\examples{

# download all suggested packages
if (FALSE) {
  install_suggested("easystats")
}

# listing all reverse dependencies of easystats packages
show_reverse_dependencies()

# listing all soft/weak dependencies of easystats packages
show_suggested()

}
