% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centree.R
\name{centree}
\alias{centree}
\title{Ward-dendrogeam of centroids of partitioning models}
\usage{
centree(drclust_out)
}
\arguments{
\item{drclust_out}{Output of either doublekm, redkm, factkm or dpcakm.}
}
\value{
\item{centroids-dkm}{Centroids x centroids distance matrix.}
}
\description{
Plots the Ward-dendrogram of the centroids of a partitioning model. The plot is useful as a diagnosis tool for the choice o the number of clusters.
}
\examples{
# Iris data 
# Loading the numeric variables of iris data
iris <- as.matrix(iris[,-5]) 

dc_out <- dpcakm(iris, 20, 3)
d <- centree(dc_out)

}
\references{
Ward J. H. (1963) "Hierarchical Grouping to Optimize an Objective Function" <doi:10.1080/01621459.1963.10500845>
}
\author{
Ionel Prunila, Maurizio Vichi
}
