% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{rerootTree}
\alias{rerootTree}
\title{Reroot phylogenetic tree to have its germline sequence at a zero-length branch
to a node which is the direct ancestor of the tree's UCA. Assigns \code{uca}
to be the ancestral node to the tree's germline sequence, as \code{germid} as
the tree's germline sequence ID.}
\usage{
rerootTree(tree, germline, min = 0.001, verbose = 1)
}
\arguments{
\item{tree}{An ape \code{phylo} object}

\item{germline}{ID of the tree's predicted germline sequence}

\item{min}{Maximum allowed branch length from germline to root}

\item{verbose}{amount of rubbish to print}
}
\value{
\code{phylo} object rooted at the specified germline
}
\description{
Reroot phylogenetic tree to have its germline sequence at a zero-length branch
to a node which is the direct ancestor of the tree's UCA. Assigns \code{uca}
to be the ancestral node to the tree's germline sequence, as \code{germid} as
the tree's germline sequence ID.
}
