% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_credit_plots.R
\name{partial_credit_contour_plot}
\alias{partial_credit_contour_plot}
\title{Generate contour plot for partial credit analysis}
\usage{
partial_credit_contour_plot(
  y1 = NULL,
  y2 = NULL,
  n1 = NULL,
  n2 = NULL,
  summary_obj = NULL,
  data_type = c("freq", "prop"),
  pc_inc = 10,
  contour_inc = 1
)
}
\arguments{
\item{y1, y2}{Numeric vectors of DOOR proportion or frequency distribution for group 1, group 2.
The entries should be ordered from most desirable to least desirable}

\item{n1, n2}{Sample sizes of group 1, group 2; must be specified if method = "prop"}

\item{summary_obj}{An object returned by \code{individual_to_summary()}; Alternative
input for y1 and y2}

\item{data_type}{Either "freq" for frequency input or "prop" for proportion input
when using y1 and y2}

\item{pc_inc}{Increment of partial credits}

\item{contour_inc}{Increment of contour lines}
}
\value{
A graph object
}
\description{
The contour plot is for sensitivity analysis. Currently it supports given DOOR
outcome categories of three or four. The contour plot assigns every combinations
of grade keys given a DOOR outcome distribution
}
\examples{
y1 <- c(60, 30, 10)
y2 <- c(50, 40, 10)
partial_credit_contour_plot(y1, y2)
}
