% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{ds_entropy}
\alias{ds_entropy}
\alias{entropy}
\title{Compute Entropy Index}
\usage{
ds_entropy(.data, .cols, .name, .comp = FALSE)

entropy(..., .data = dplyr::across(everything()))
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble}}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with entropy index. Leave missing to return a vector.}

\item{.comp}{Default is FALSE. FALSE returns the sum, TRUE returns the components.}

\item{...}{arguments to forward to ds_entropy from entropy}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Entropy Index
}
\examples{
data("de_county")
ds_entropy(de_county, c(pop_white, starts_with('pop_')))
ds_entropy(de_county, starts_with('pop_'), 'entropy')
}
\concept{evenness}
