% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothPolarizedGenotypes.r
\name{smoothPolarizedGenotypes}
\alias{smoothPolarizedGenotypes}
\title{Smooth Polarized Genotype States}
\usage{
smoothPolarizedGenotypes(
  genotypes,
  includedSites,
  ChosenSites = "all",
  windows = NULL,
  windowSize = 250000,
  ...
)
}
\arguments{
\item{genotypes}{A character matrix comprising of _012 encodings.}

\item{includedSites}{A character path to a file with columns \code{CHROM} and \code{POS}.}

\item{ChosenSites}{A logical vector indicating which sites are to be included in the
analysis.}

\item{windows}{A two-column numeric matrix with indices of start and end positions for
windows for all markers indicated by \code{ChosenSites}. If \code{windows = NULL}, the function
calculates the windows using \link{rank2map}.}

\item{windowSize}{A numeric window size for metric conversion in base-pairs.}

\item{...}{Additional arguments to be passed to \link{rank2map} if \code{windows = NULL}.}
}
\description{
This function smooths polarized genotype states using a Laplace kernel density estimation.
It calculates a smoothed version of the genotype states over specified physical extent
of genomic content around a site. At each
genomic position, the function returns a weighted mode of the genomic state.
}
\details{
Ensure that \code{ChosenSites} match those used to import polarized genotypes.

The function uses a truncated and scaled Laplace kernel to weight the genotype states
within a window around each marker position,
based on physical positions of the markers.

The Laplace kernel weights are calculated for physical positions of the sites centered at
the site being smoothed as:
\deqn{\frac{10}{19} \exp\left(\frac{-x}{b}\right),}
when \eqn{x < 0}, meaning that the site \eqn{x} is upstream of the site being smoothed, and as:
\deqn{\frac{10}{19} \exp\left(\frac{x}{b}\right),}
when \eqn{x \geq 0}, meaning that the site is downstream.
The value \eqn{x} is the position of a neighbouring site relative to the site being
smoothed, and \eqn{b} is the scale parameter of the Laplace kernel.
The scale parameter is equal to:
\deqn{b = \frac{\text{windowSize}}{2 \ln(20)}.}
}
\examples{
 \dontrun{
 # Run this example in a working directory with write permissions
 myo <- system.file("extdata", "myotis.vcf", package = "diemr")
 vcf2diem(myo, "myo")
 fit <- diem("myo-001.txt", ChosenInds = 1:14)
 gen <- importPolarized("myo-001.txt", changePolarity = fit$markerPolarity, ChosenInds = 1:14)
 h <- apply(gen, 1, \(x) pHetErrOnStateCount(sStateCount(x)))[1, ]
 gen2 <- smoothPolarizedGenotypes(genotypes = gen, 
    includedSites = "myo-includedSites.txt", windowSize = 50)
 plotPolarized(gen, h)
 plotPolarized(gen2, h)
 }
}
\seealso{
\link{rank2map}
}
