% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggte.R
\name{aggte}
\alias{aggte}
\title{Aggregate Group-Time Average Treatment Effects}
\usage{
aggte(
  MP,
  type = "group",
  balance_e = NULL,
  min_e = -Inf,
  max_e = Inf,
  na.rm = FALSE,
  bstrap = NULL,
  biters = NULL,
  cband = NULL,
  alp = NULL,
  clustervars = NULL
)
}
\arguments{
\item{MP}{an MP object (i.e., the results of the \code{\link[=att_gt]{att_gt()}} method)}

\item{type}{Which type of aggregated treatment effect parameter to compute.
One option is "simple" (this just computes a weighted average of all
group-time average treatment effects with weights proportional to group
size).  Other options are "dynamic" (this computes average effects across
different lengths of exposure to the treatment and is similar to an
"event study"; here the overall effect averages the effect of the
treatment across all positive lengths of exposure); "group" (this
is the default option and
computes average treatment effects across different groups; here
the overall effect averages the effect across different groups); and
"calendar" (this computes average treatment effects across different
time periods; here the overall effect averages the effect across each
time period).}

\item{balance_e}{If set (and if one computes dynamic effects), it balances
the sample with respect to event time.  For example, if \code{balance.e=2},
\code{aggte} will drop groups that are not exposed to treatment for
at least three periods. (the initial period when \code{e=0} as well as the
next two periods when \code{e=1} and the \code{e=2}).  This ensures that
the composition of groups does not change when event time changes.}

\item{min_e}{For event studies, this is the smallest event time to compute
dynamic effects for.  By default, \code{min_e = -Inf} so that effects at
all lengths of exposure are computed.}

\item{max_e}{For event studies, this is the largest event time to compute
dynamic effects for.  By default, \code{max_e = Inf} so that effects at
all lengths of exposure are computed.}

\item{na.rm}{Logical value if we are to remove missing Values from analyses. Defaults is FALSE.}

\item{bstrap}{Boolean for whether or not to compute standard errors using
the multiplier bootstrap.  If standard errors are clustered, then one
must set \code{bstrap=TRUE}. Default is value set in the MP object.  If bstrap is \code{FALSE}, then analytical
standard errors are reported.}

\item{biters}{The number of bootstrap iterations to use.  The default is the value set in the MP object,
and this is only applicable if \code{bstrap=TRUE}.}

\item{cband}{Boolean for whether or not to compute a uniform confidence
band that covers all of the group-time average treatment effects
with fixed probability \code{1-alp}.  In order to compute uniform confidence
bands, \code{bstrap} must also be set to \code{TRUE}.  The default is
the value set in the MP object}

\item{alp}{the significance level, default is value set in the MP object.}

\item{clustervars}{A vector of variables to cluster on.  At most, there
can be two variables (otherwise will throw an error) and one of these
must be the same as idname which allows for clustering at the individual
level. Default is the variables set in the MP object}
}
\value{
An \code{\link{AGGTEobj}} object that holds the results from the
aggregation
}
\description{
A function to take group-time average treatment effects
and aggregate them into a smaller number of parameters.  There are
several possible aggregations including "simple", "dynamic", "group",
and "calendar."
}
\section{Examples}{


Initial ATT(g,t) estimates from \code{\link[=att_gt]{att_gt()}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data(mpdta)
out <- att_gt(yname="lemp",
               tname="year",
               idname="countyreal",
               gname="first.treat",
               xformla=NULL,
               data=mpdta)
}\if{html}{\out{</div>}}

You can aggregate the ATT(g,t) in many ways.

\strong{Overall ATT:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{aggte(out, type = "simple")
#> 
#> Call:
#> aggte(MP = out, type = "simple")
#> 
#> Reference: Callaway, Brantly and Pedro H.C. Sant'Anna.  "Difference-in-Differences with Multiple Time Periods." Journal of Econometrics, Vol. 225, No. 2, pp. 200-230, 2021. <https://doi.org/10.1016/j.jeconom.2020.12.001>, <https://arxiv.org/abs/1803.09015> 
#> 
#> 
#>    ATT    Std. Error     [ 95\%  Conf. Int.]  
#>  -0.04         0.013    -0.0654     -0.0145 *
#> 
#> 
#> ---
#> Signif. codes: `*' confidence band does not cover 0
#> 
#> Control Group:  Never Treated,  Anticipation Periods:  0
#> Estimation Method:  Doubly Robust
}\if{html}{\out{</div>}}

\strong{Dynamic ATT (Event-Study):}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{aggte(out, type = "dynamic")
#> 
#> Call:
#> aggte(MP = out, type = "dynamic")
#> 
#> Reference: Callaway, Brantly and Pedro H.C. Sant'Anna.  "Difference-in-Differences with Multiple Time Periods." Journal of Econometrics, Vol. 225, No. 2, pp. 200-230, 2021. <https://doi.org/10.1016/j.jeconom.2020.12.001>, <https://arxiv.org/abs/1803.09015> 
#> 
#> 
#> Overall summary of ATT's based on event-study/dynamic aggregation:  
#>      ATT    Std. Error     [ 95\%  Conf. Int.]  
#>  -0.0772          0.02    -0.1165      -0.038 *
#> 
#> 
#> Dynamic Effects:
#>  Event time Estimate Std. Error [95\% Simult.  Conf. Band]  
#>          -3   0.0305     0.0150       -0.0060      0.0670  
#>          -2  -0.0006     0.0139       -0.0344      0.0333  
#>          -1  -0.0245     0.0150       -0.0610      0.0121  
#>           0  -0.0199     0.0117       -0.0485      0.0087  
#>           1  -0.0510     0.0168       -0.0919     -0.0100 *
#>           2  -0.1373     0.0380       -0.2299     -0.0446 *
#>           3  -0.1008     0.0360       -0.1887     -0.0130 *
#> ---
#> Signif. codes: `*' confidence band does not cover 0
#> 
#> Control Group:  Never Treated,  Anticipation Periods:  0
#> Estimation Method:  Doubly Robust
}\if{html}{\out{</div>}}

\strong{ATT for each group:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{aggte(out, type = "group")
#> 
#> Call:
#> aggte(MP = out, type = "group")
#> 
#> Reference: Callaway, Brantly and Pedro H.C. Sant'Anna.  "Difference-in-Differences with Multiple Time Periods." Journal of Econometrics, Vol. 225, No. 2, pp. 200-230, 2021. <https://doi.org/10.1016/j.jeconom.2020.12.001>, <https://arxiv.org/abs/1803.09015> 
#> 
#> 
#> Overall summary of ATT's based on group/cohort aggregation:  
#>     ATT    Std. Error     [ 95\%  Conf. Int.]  
#>  -0.031        0.0127    -0.0558     -0.0062 *
#> 
#> 
#> Group Effects:
#>  Group Estimate Std. Error [95\% Simult.  Conf. Band]  
#>   2004  -0.0797     0.0308       -0.1461     -0.0134 *
#>   2006  -0.0229     0.0175       -0.0606      0.0148  
#>   2007  -0.0261     0.0163       -0.0612      0.0091  
#> ---
#> Signif. codes: `*' confidence band does not cover 0
#> 
#> Control Group:  Never Treated,  Anticipation Periods:  0
#> Estimation Method:  Doubly Robust
}\if{html}{\out{</div>}}

\strong{ATT for each calendar year:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{aggte(out, type = "calendar")
#> 
#> Call:
#> aggte(MP = out, type = "calendar")
#> 
#> Reference: Callaway, Brantly and Pedro H.C. Sant'Anna.  "Difference-in-Differences with Multiple Time Periods." Journal of Econometrics, Vol. 225, No. 2, pp. 200-230, 2021. <https://doi.org/10.1016/j.jeconom.2020.12.001>, <https://arxiv.org/abs/1803.09015> 
#> 
#> 
#> Overall summary of ATT's based on calendar time aggregation:  
#>      ATT    Std. Error     [ 95\%  Conf. Int.]  
#>  -0.0417        0.0177    -0.0765     -0.0069 *
#> 
#> 
#> Time Effects:
#>  Time Estimate Std. Error [95\% Simult.  Conf. Band]  
#>  2004  -0.0105     0.0248       -0.0689      0.0479  
#>  2005  -0.0704     0.0313       -0.1443      0.0035  
#>  2006  -0.0488     0.0199       -0.0956     -0.0020 *
#>  2007  -0.0371     0.0143       -0.0708     -0.0033 *
#> ---
#> Signif. codes: `*' confidence band does not cover 0
#> 
#> Control Group:  Never Treated,  Anticipation Periods:  0
#> Estimation Method:  Doubly Robust
}\if{html}{\out{</div>}}
}

