% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detour.R
\name{detour}
\alias{detour}
\title{Initiate a detour visualisation}
\usage{
detour(.data, mapping)
}
\arguments{
\item{.data}{a data frame, tibble, or crosstalk::SharedData object}

\item{mapping}{a mapping of data columns to aesthetic values using the
\code{tour_aes} function. The only required aesthetic is \code{projection}, which
determines which columns are used to generate the tour path and supports tidy selection.}
}
\value{
A \code{detour} object containing information about the tour path and
its parameters
}
\description{
This function initialises a \code{detour} object which, along with the
\code{tour_path} and \code{show_functions} is used to build a detour visualisation.
}
\examples{
detour(tourr::flea, tour_aes(projection = -species, colour = species)) |>
  tour_path(grand_tour(3), fps = 60) |>
  show_scatter(alpha = 0.7, axes = FALSE)
}
