% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.kmm}
\alias{summary.kmm}
\title{Extract summary from \code{kmm} object, including two-sample significance
test for homogeneity of the numerator and denominator samples}
\usage{
\method{summary}{kmm}(
  object,
  test = FALSE,
  n_perm = 100,
  parallel = FALSE,
  cluster = NULL,
  min_pred = 1e-06,
  ...
)
}
\arguments{
\item{object}{Object of class \code{kmm}}

\item{test}{logical indicating whether to statistically test for homogeneity
of the numerator and denominator samples.}

\item{n_perm}{Scalar indicating number of permutation samples}

\item{parallel}{\code{logical} indicating to run the permutation test in parallel}

\item{cluster}{\code{NULL} or a cluster object created by \code{makeCluster}. If
\code{NULL} and \code{parallel = TRUE}, it uses the number of available cores
minus 1.}

\item{min_pred}{Scalar indicating the minimum value for the predicted density
ratio values (used in the divergence statistic) to avoid negative density
ratio values.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Summary of the fitted density ratio model
}
\description{
Extract summary from \code{kmm} object, including two-sample significance
test for homogeneity of the numerator and denominator samples
}
\examples{
set.seed(123)
# Fit model
dr <- kmm(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
kmm(numerator_small, denominator_small,
    nsigma = 5, ncenters = 100, nfold = 10,
    constrained = TRUE)

}
