% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral.R
\name{spectral}
\alias{spectral}
\title{Spectral series based density ratio estimation}
\usage{
spectral(
  df_numerator,
  df_denominator,
  m = NULL,
  scale = "numerator",
  nsigma = 10,
  sigma_quantile = NULL,
  sigma = NULL,
  ncenters = NULL,
  cv = TRUE,
  nfold = 10,
  parallel = FALSE,
  nthreads = NULL,
  progressbar = TRUE
)
}
\arguments{
\item{df_numerator}{\code{data.frame} with exclusively numeric variables with
the numerator samples}

\item{df_denominator}{\code{data.frame} with exclusively numeric variables
with the denominator samples (must have the same variables as
\code{df_denominator})}

\item{m}{Integer vector indicating the number of eigenvectors to use in the
spectral series expansion. Defaults to 50 evenly spaced values between 1 and
the number of denominator samples (or the largest number of samples that can
be used as centers in the cross-validation scheme).}

\item{scale}{\code{"numerator"}, \code{"denominator"}, or \code{NULL},
indicating whether to standardize each numeric variable according to the
numerator means and standard deviations, the denominator means and standard
deviations, or apply no standardization at all.}

\item{nsigma}{Integer indicating the number of sigma values (bandwidth
parameter of the Gaussian kernel gram matrix) to use in cross-validation.}

\item{sigma_quantile}{\code{NULL} or numeric vector with probabilities to
calculate the quantiles of the distance matrix to obtain sigma values. If
\code{NULL}, \code{nsigma} values between \code{0.05} and \code{0.95} are
used.}

\item{sigma}{\code{NULL} or a scalar value to determine the bandwidth of the
Gaussian kernel gram matrix. If \code{NULL}, \code{nsigma} values between
\code{0.05} and \code{0.95} are used.}

\item{ncenters}{integer If smaller than the number of denominator observations,
an approximation to the eigenvector expansion based on only ncenters samples
is performed, instead of the full expansion. This can be useful for large
datasets. Defaults to \code{NULL}, such that all denominator samples are used.}

\item{cv}{logical indicating whether to use cross-validation to determine the
optimal sigma value and the optimal number of eigenvectors.}

\item{nfold}{Integer indicating the number of folds to use in the
cross-validation scheme. If \code{cv} is \code{FALSE}, this parameter is
ignored.}

\item{parallel}{logical indicating whether to use parallel processing in the
cross-validation scheme.}

\item{nthreads}{\code{NULL} or integer indicating the number of threads to
use for parallel processing. If parallel processing is enabled, it defaults
to the number of available threads minus one.}

\item{progressbar}{Logical indicating whether or not to display a progressbar.}
}
\value{
\code{spectral}-object, containing all information to calculate the
density ratio using optimal sigma and optimal spectral series expansion.
}
\description{
Spectral series based density ratio estimation
}
\examples{
set.seed(123)
# Fit model
dr <- spectral(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
spectral(numerator_small, denominator_small, sigma = 2)
}
\references{
Izbicki, R., Lee, A. & Schafer, C. (2014). High-Dimensional
Density Ratio Estimation with Extensions to Approximate Likelihood Computation.
\if{html}{\out{<i>}}Proceedings of Machine Learning Research\if{html}{\out{</i>}} 33, 420-429. Available from
\url{https://proceedings.mlr.press/v33/izbicki14.html}.
}
