% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgmyc_tbl.R
\name{bgmyc_tbl}
\alias{bgmyc_tbl}
\title{Turns bGMYC Results Into a Tibble}
\source{
Reid N.M., Carstens B.C. 2012. Phylogenetic estimation error can decrease
the accuracy of species delimitation: a Bayesian implementation of the general
mixed Yule-coalescent model. BMC Evolutionary Biology 12 (196).
}
\usage{
bgmyc_tbl(bgmyc_res, ppcutoff = 0.05, delimname = "bgmyc")
}
\arguments{
\item{bgmyc_res}{Output from \link[bGMYC:bgmyc.singlephy]{bgmyc.singlephy}.}

\item{ppcutoff}{Posterior probability threshold for clustering samples into
species partitions. See \link[bGMYC:bgmyc.point]{bgmyc.point} for details. Default to 0.05.}

\item{delimname}{Character. String to rename the delimitation method in the table. Default to 'bgmyc'.}
}
\value{
an object of class \link[tibble:tbl_df-class]{tbl_df}.
}
\description{
\code{bgmyc_tbl()} processes output from \link[bGMYC:bgmyc.singlephy]{bgmyc.singlephy} into an
object of class \link[tibble:tbl_df-class]{tbl_df}.
}
\details{
\code{bGMYC} package uses \link[bGMYC:spec.probmat]{spec.probmat} to create a
matrix of probability of conspecificity and \link[bGMYC:bgmyc.point]{bgmyc.point}
to split samples into a list which individuals
meets the threshold specified by \code{ppcutoff}. \code{bgmyc_tbl()} wraps up these
two functions into a single one and turns these inputs into a tibble which matches
the output from \link{gmyc_tbl} and \link{locmin_tbl}.
}
\examples{

\donttest{
# run bGMYC
bgmyc_res <- bGMYC::bgmyc.singlephy(ape::as.phylo(geophagus_beast),
  mcmc = 11000,
  burnin = 1000,
  thinning = 100,
  t1 = 2,
  t2 = ape::Ntip(geophagus_beast),
  start = c(1, 0.5, 50)
)

# create a tibble
bgmyc_df <- bgmyc_tbl(bgmyc_res, ppcutoff = 0.05)

# check
bgmyc_df
}

}
\author{
Noah M. Reid.
}
