% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconcile.R
\name{get_same_class}
\alias{get_same_class}
\title{Harmonizes variable classes between two data frames}
\usage{
get_same_class(old_df, new_df)
}
\arguments{
\item{old_df}{A data frame containing the preceding version of the data,
used as the reference for comparison.}

\item{new_df}{A data frame containing the most recent version of the data.}
}
\value{
A modified version of `old_df` in which all shared columns are coerced to match the variable classes of `new_df`.
}
\description{
This function aligns the classes of variables in `old_df` with those of
their corresponding variables in `new_df`. For each column name shared
across both data frames, the function detects the class in `new_df` and
coerces the matching column in `old_df` to the same class. Supported
conversions include `character`, `numeric`, `integer`, `logical`, `factor`,
and `Date`. Any variable whose class is not explicitly handled is left
unchanged.
}
\author{
Lukasz Andrzejewski
}
