% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibrecord.R
\name{bibrecord}
\alias{bibrecord}
\title{Create a modern bibrecord-compatible metadata object}
\usage{
bibrecord(
  title,
  author,
  contributor = NULL,
  publisher = NULL,
  year = NULL,
  date = Sys.Date(),
  identifier = NULL,
  subject = NULL,
  ...
)
}
\arguments{
\item{title}{A character string, the dataset title.}

\item{author}{A list or vector of \code{utils::person} objects. Mapped to
\code{creator} in DataCite and DCTERMS.}

\item{contributor}{Optional list/vector of \code{utils::person}. Contributor roles
are merged if repeated.}

\item{publisher}{Character string or \code{person}. The publishing entity.}

\item{year}{Publication year. Derived from \code{date} if not explicitly provided.}

\item{date}{A character string or \code{Date} object.}

\item{identifier}{Unique identifier (e.g., DOI).}

\item{subject}{Optional keyword(s) or controlled vocabulary string.}

\item{...}{Additional fields (e.g., language, format, rights, description).}
}
\value{
An object of class \code{bibrecord} and \code{bibentry}. bibrecord(title =
"Gross domestic product, volumes", author = person("Eurosat"), publisher =
person("Eurostat"), identifier = "https://doi.org/10.2908/TEINA011", date =
as.Date("2025-05-20"))
}
\description{
Create a \code{utils::bibentry}-compatible object extended with
standard Dublin Core and DataCite-compatible fields. This serves as a
unified metadata structure for use in both \code{dublincore()} and \code{datacite()}
functions.
}
