% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RatingTables.R
\name{RenameRatingTable}
\alias{RenameRatingTable}
\title{Renames a rating table to a different name.}
\usage{
RenameRatingTable(project, ratingTableId, ratingTableName)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{ratingTableId}{character. The ID of the rating table.}

\item{ratingTableName}{character. The new name for the rating table.}
}
\value{
An S3 object of class 'dataRobotRatingTable' summarizing all
  available information about the renamed rating table.
}
\description{
Renames a rating table to a different name.
}
\examples{
\dontrun{
  projectId <- "5984b4d7100d2b31c1166529"
  ratingTableId <- "5984b4d7100d2b31c1166529"
  RenameRatingTable(projectId, ratingTableId, "Renamed Table")
}
}
