% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blueprints.R
\name{ListBlueprints}
\alias{ListBlueprints}
\title{Retrieve the list of available blueprints for a project}
\usage{
ListBlueprints(project)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}
}
\value{
An S3 object of class 'listOfBlueprints', a list
with one element for each recommended blueprint in the
associated project. For more information see GetBlueprint()
}
\description{
This function returns the list of available blueprints
for a specified modeling project, as an S3 object of class
listOfBlueprints; see Value.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  ListBlueprints(projectId)
}
}
