% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCindex.R
\name{getCindex}
\alias{getCindex}
\title{Compute C index for a Cox model}
\usage{
getCindex(pred, y, weights = rep(1, nrow(y)))
}
\arguments{
\item{pred}{A vector of predictions.}

\item{y}{Survival response variable, must be a \code{Surv} or
\code{stratifySurv} object.}

\item{weights}{Observation weights (default is all equal to 1).}
}
\value{
The C index for the predictions (a single numeric value).
}
\description{
Computes Harrel's C (concordance) index for predictions, taking
censoring into account.
}
\examples{
set.seed(1)
pred <- rep(1:2, length.out = 10)
y <- survival::Surv(exp(rnorm(10)), rbinom(10, 1, 0.5))
getCindex(pred, y)

}
