% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_functions.R
\name{predict_functions}
\alias{predict_functions}
\title{Examples of predict_fn functions}
\usage{
predict_functions(name)
}
\arguments{
\item{name}{Name of model to get predict function for,
 as it appears in the following table.

 The \strong{Model HParams} column lists hyperparameters used
 in the respective model function.

 \tabular{rrr}{
  \strong{Name} \tab \strong{Function} \tab \strong{Model HParams} \cr
  "lm" \tab \code{\link[stats:lm]{stats::lm()}} \tab \cr
  "lmer" \tab \code{\link[lme4:lmer]{lme4::lmer()}} \tab \cr
  "glm_binomial" \tab \code{\link[stats:lm]{stats::glm()}} \tab \code{family = "binomial"}\cr
  "glmer_binomial" \tab \code{\link[lme4:glmer]{lme4::glmer()}} \tab \code{family = "binomial"}\cr
  "svm_gaussian" \tab \code{\link[e1071:svm]{e1071::svm()}} \tab \code{type = "eps-regression"}\cr
  "svm_binomial" \tab \code{\link[e1071:svm]{e1071::svm()}} \tab \code{type = "C-classification"}, \code{probability = TRUE}\cr
  "svm_multinomial" \tab \code{\link[e1071:svm]{e1071::svm()}} \tab \code{type = "C-classification"}, \code{probability = TRUE}\cr
  "naive_bayes" \tab \code{\link[e1071:naiveBayes]{e1071::naiveBayes()}} \tab \cr
  "nnet_multinom" \tab \code{\link[nnet:multinom]{nnet::multinom()}} \tab \cr
  "nnet_gaussian" \tab \code{\link[nnet:multinom]{nnet::nnet()}} \tab \code{linout = TRUE} \cr
  "nnet_binomial" \tab \code{\link[nnet:multinom]{nnet::nnet()}} \tab \cr
  "randomForest_gaussian" \tab \code{\link[randomForest:randomForest]{randomForest::randomForest()}} \tab \cr
  "randomForest_binomial" \tab \code{\link[randomForest:randomForest]{randomForest::randomForest()}} \tab \cr
  "randomForest_multinomial" \tab \code{\link[randomForest:randomForest]{randomForest::randomForest()}} \tab \cr
 }}
}
\value{
A function with the following form:

 \code{function(test_data, model, formula, hyperparameters, train_data) \{}

 \verb{    }\code{# Use model to predict test_data}

 \verb{    }\code{# Return predictions}

 \code{\}}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Examples of predict functions that can be used in
 \code{\link[cvms:cross_validate_fn]{cross_validate_fn()}}.
 They can either be used directly or be starting points.
}
\seealso{
Other example functions: 
\code{\link{model_functions}()},
\code{\link{preprocess_functions}()},
\code{\link{update_hyperparameters}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{example functions}
