% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{minnow_sd}
\alias{minnow_sd}
\title{A fitted GUTS-RED-SD scenario of the fathead minnow}
\format{
An object of class \code{GutsRedSd} of length 1.
}
\source{
https://mosaic.univ-lyon1.fr/guts
}
\usage{
minnow_sd
}
\description{
The example scenario consists of a fitted \link[=GUTS_RED_SD]{GUTS-RED-SD}
model and a constant exposure series. Model parameters were derived from a
typical four-day acute fish toxicity study of the \emph{fathead minnow} by
Geiger \emph{et al.} (1988).
The study evaluated the effect of \emph{chlorpyrifos} concentrations in water on
survival of \emph{fathead minnows}.
}
\details{
The toxicity dataset used for parameter calibration is also referred to as
\emph{GUTS Ring-test dataset C} by EFSA (2018). Fitted parameters were estimated
using the \emph{morse} package.

The exposure series of the example scenario is a constant concentration of 1.0 µmol/L
over a period of four days with a daily time step.
}
\examples{
# Print scenario parameters
minnow_sd

# Run the example scenario
minnow_sd \%>\% simulate()
}
\references{
Geiger D.L., Call D.J., and Brooke L.T., 1988: \emph{Acute toxicities of organic
chemicals to fathead minnows (Pimephales promelas): Volume IV}, pp. 195-197.
University of Wisconsin-Superior, Center for Lake Superior Environmental Studies.
ISBN 9780961496838.

EFSA PPR Panel (EFSA Panel on Plant Protection Products and their Residues),
Ockleford C, Adriaanse P, Berny P, et al., 2018: \emph{Scientific Opinion on the
state of the art of Toxicokinetic/Toxicodynamic (TKTD) effect models for
regulatory risk assessment of pesticides for aquatic organisms}. EFSA Journal 2018;
16(8):5377, 188 pp. \doi{10.2903/j.efsa.2018.5377}
}
\seealso{
\link{GUTS-RED-models}
}
\keyword{datasets}
