% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_chemical_mol}
\alias{get_chemical_mol}
\title{Get mol file by DTXSID or DTXCID}
\usage{
get_chemical_mol(
  DTXSID = NULL,
  DTXCID = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{Chemical identifier DTXSID}

\item{DTXCID}{Chemical identifier DTXCID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A character string giving a mol file representation
}
\description{
Get mol file by DTXSID or DTXCID
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull mol file for BPA by dtxsid
bpa_mol <- get_chemical_mol(DTXSID = 'DTXSID7020182')
# Pull mol file for BPA by dtxcid
bpa_mol <- get_chemical_mol(DTXCID = 'DTXCID30182')
\dontshow{\}) # examplesIf}
}
