% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{clean_names_with_labels}
\alias{clean_names_with_labels}
\title{Cleans names of a dataframe while retaining old names as labels}
\usage{
clean_names_with_labels(
  df,
  except = NULL,
  .fun = getOption("crosstable_clean_names_fun")
)
}
\arguments{
\item{df}{a data.frame}

\item{except}{<\code{\link[tidyselect:language]{tidy-select}}> columns that should not be renamed.}

\item{.fun}{the function used to clean the names. Default function is limited; if the cleaning is not good enough you could use janitor::make_clean_names()}
}
\value{
A dataframe with clean names and label attributes
}
\description{
Cleans names of a dataframe while retaining old names as labels
}
\examples{
#options(crosstable_clean_names_fun=janitor::make_clean_names)
x = data.frame("name with space"=1, TwoWords=1, "total $ (2009)"=1, àccénts=1,
               check.names=FALSE)
cleaned = clean_names_with_labels(x, except=TwoWords)
cleaned \%>\% names()
cleaned \%>\% get_label()
}
\author{
Dan Chaltiel
}
