% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher.R
\name{crew_launcher}
\alias{crew_launcher}
\title{Create an abstract launcher.}
\usage{
crew_launcher(
  name = NULL,
  workers = 1L,
  seconds_interval = 1,
  seconds_timeout = 60,
  seconds_launch = 30,
  seconds_idle = 300,
  seconds_wall = Inf,
  seconds_exit = NULL,
  tasks_max = Inf,
  tasks_timers = 0L,
  reset_globals = NULL,
  reset_packages = NULL,
  reset_options = NULL,
  garbage_collection = NULL,
  crashes_error = NULL,
  launch_max = NULL,
  tls = crew::crew_tls(),
  processes = NULL,
  r_arguments = c("--no-save", "--no-restore"),
  options_metrics = crew::crew_options_metrics()
)
}
\arguments{
\item{name}{Character string, name of the launcher. If the name is
\code{NULL}, then a name is automatically generated when the launcher starts.}

\item{workers}{Maximum number of workers to run concurrently
when auto-scaling, excluding task retries and manual calls to \code{launch()}.
Special workers allocated for task retries
do not count towards this limit, so the number of workers running at a
given time may exceed this maximum.
A smaller number of workers may run if the number of executing tasks
is smaller than the supplied value of the \code{workers} argument.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete. In certain cases, exponential
backoff is used with this argument passed to \code{seconds_max}
in a \code{\link[=crew_throttle]{crew_throttle()}} object.}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete,
such as checking \code{mirai::status()}.}

\item{seconds_launch}{Seconds of startup time to allow.
A worker is unconditionally assumed to be alive
from the moment of its launch until \code{seconds_launch} seconds later.
After \code{seconds_launch} seconds, the worker is only
considered alive if it is actively connected to its assign websocket.}

\item{seconds_idle}{Maximum number of seconds that a worker can idle
since the completion of the last task. If exceeded, the worker exits.
But the timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{idletime} argument of \code{mirai::daemon()}. \code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, so please allow enough idle
time for a new worker to be delegated a new task.}

\item{seconds_wall}{Soft wall time in seconds.
The timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{walltime} argument of \code{mirai::daemon()}.}

\item{seconds_exit}{Deprecated on 2023-09-21 in version 0.5.0.9002.
No longer necessary.}

\item{tasks_max}{Maximum number of tasks that a worker will do before
exiting. See the \code{maxtasks} argument of \code{mirai::daemon()}.
\code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, it is recommended to set
\code{tasks_max} to a value greater than 1.}

\item{tasks_timers}{Number of tasks to do before activating
the timers for \code{seconds_idle} and \code{seconds_wall}.
See the \code{timerstart} argument of \code{mirai::daemon()}.}

\item{reset_globals}{Deprecated on 2025-05-30 (\code{crew} version 1.1.2.9004).
Please use the \code{reset_globals} option of \code{\link[=crew_controller]{crew_controller()}}
instead.}

\item{reset_packages}{Deprecated on 2025-05-30 (\code{crew} version 1.1.2.9004).
Please use the \code{reset_packages} option of \code{\link[=crew_controller]{crew_controller()}}
instead.}

\item{reset_options}{Deprecated on 2025-05-30 (\code{crew} version 1.1.2.9004).
Please use the \code{reset_options} option of \code{\link[=crew_controller]{crew_controller()}}
instead.}

\item{garbage_collection}{Deprecated on 2025-05-30
(\code{crew} version 1.1.2.9004).
Please use the \code{garbage_collection} option of
\code{\link[=crew_controller]{crew_controller()}} instead.}

\item{crashes_error}{Deprecated on 2025-01-13 (\code{crew} version 0.10.2.9002).}

\item{launch_max}{Deprecated on 2024-11-04 (\code{crew} version 0.10.2.9002).}

\item{tls}{A TLS configuration object from \code{\link[=crew_tls]{crew_tls()}}.}

\item{processes}{\code{NULL} or positive integer of length 1,
number of local processes to
launch to allow worker launches to happen asynchronously. If \code{NULL},
then no local processes are launched. If 1 or greater, then the launcher
starts the processes on \code{start()} and ends them on \code{terminate()}.
Plugins that may use these processes should run asynchronous calls
using \code{launcher$async$eval()} and expect a \code{mirai} task object
as the return value.}

\item{r_arguments}{Optional character vector of command line arguments
to pass to \code{Rscript} (non-Windows) or \code{Rscript.exe} (Windows)
when starting a worker. Example:
\code{r_arguments = c("--vanilla", "--max-connections=32")}.}

\item{options_metrics}{Either \code{NULL} to opt out of resource metric logging
for workers, or an object from \code{\link[=crew_options_metrics]{crew_options_metrics()}} to enable
and configure resource metric logging for workers.
For resource logging to run,
the \code{autometric} R package version 0.1.0 or higher
must be installed.}
}
\description{
This function is useful for inheriting argument documentation
in functions that create custom third-party launchers. See
\verb{@inheritParams crew::crew_launcher} in the source code file of
\code{\link[=crew_launcher_local]{crew_launcher_local()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
launcher <- crew_launcher_local()
launcher$start(url = client$url, profile = client$profile)
launcher$launch()
task <- mirai::mirai("result", .compute = client$profile)
mirai::call_mirai(task)
task$data
client$terminate()
}
}
\seealso{
Other launcher: 
\code{\link{crew_class_launcher}}
}
\concept{launcher}
