% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_learning.R
\name{ml_learning}
\alias{ml_learning}
\title{Cram ML: Generalized ML Learning}
\usage{
ml_learning(
  data,
  formula = NULL,
  batch,
  parallelize_batch = FALSE,
  loss_name = NULL,
  caret_params = NULL,
  custom_fit = NULL,
  custom_predict = NULL,
  custom_loss = NULL,
  n_cores = detectCores() - 1,
  classify = FALSE
)
}
\arguments{
\item{data}{A matrix or data frame of features. Must include the target variable.}

\item{formula}{Formula specifying the relationship between the target and predictors for supervised learning.}

\item{batch}{Either an integer specifying the number of batches (randomly sampled) or a vector of length equal to the sample size indicating batch assignment for each observation.}

\item{parallelize_batch}{Logical. Whether to parallelize batch processing. Defaults to `FALSE`.}

\item{loss_name}{The name of the loss function to be used (e.g., `"se"`, `"logloss"`).}

\item{caret_params}{A list of parameters to pass to the `caret::train()` function.
- Required: `method` (e.g., `"glm"`, `"rf"`).}

\item{custom_fit}{A custom function for training user-defined models. Defaults to `NULL`.}

\item{custom_predict}{A custom function for making predictions from user-defined models. Defaults to `NULL`.}

\item{custom_loss}{Optional custom function for computing the loss of a trained model on the data. Should return a vector containing per-instance losses.}

\item{n_cores}{Number of CPU cores to use for parallel processing (`parallelize_batch = TRUE`). Defaults to `detectCores() - 1`.}

\item{classify}{Indicate if this is a classification problem. Defaults to FALSE}
}
\value{
A list containing:
  \item{final_ml_model}{The final trained ML model.}
  \item{losses}{A matrix of losses where each column represents a batch's trained model. The first column contains zeros (baseline model).}
  \item{batch_indices}{The indices of observations in each batch.}
}
\description{
This function performs batch-wise learning for machine learning models.
}
