% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\title{Cram Policy: Fit Model}
\usage{
fit_model(model, X, Y, D, model_type, learner_type, model_params, propensity)
}
\arguments{
\item{model}{An unfitted model object, as returned by `set_model`.}

\item{X}{A matrix or data frame of covariates for the samples.}

\item{Y}{A vector of outcome values.}

\item{D}{A vector of binary treatment indicators (1 for treated, 0 for untreated).}

\item{model_type}{The model type for policy learning. Options include \code{"causal_forest"}, \code{"s_learner"}, and \code{"m_learner"}. Default is \code{"causal_forest"}.}

\item{learner_type}{The learner type for the chosen model. Options include \code{"ridge"} for Ridge Regression and \code{"fnn"} for Feedforward Neural Network. Default is \code{"ridge"}.}

\item{model_params}{A list of additional parameters to pass to the model, which can be any parameter defined in the model reference package. Defaults to \code{NULL}.}

\item{propensity}{The propensity score}
}
\value{
The fitted model object.
}
\description{
This function trains a given unfitted model with the provided data and parameters,
according to model type and learner type.
}
