% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cram_policy.R
\name{cram_policy}
\alias{cram_policy}
\title{Cram Policy: Efficient Simultaneous Policy Learning and Evaluation}
\usage{
cram_policy(
  X,
  D,
  Y,
  batch,
  model_type = "causal_forest",
  learner_type = "ridge",
  baseline_policy = NULL,
  parallelize_batch = FALSE,
  model_params = NULL,
  custom_fit = NULL,
  custom_predict = NULL,
  alpha = 0.05,
  propensity = NULL
)
}
\arguments{
\item{X}{A matrix or data frame of covariates for each sample.}

\item{D}{A vector of binary treatment indicators (1 for treated, 0 for non-treated).}

\item{Y}{A vector of outcome values for each sample.}

\item{batch}{Either an integer specifying the number of batches (which will be created by random sampling) or a vector of length equal to the sample size providing the batch assignment (index) for each individual in the sample.}

\item{model_type}{The model type for policy learning. Options include \code{"causal_forest"}, \code{"s_learner"}, and \code{"m_learner"}. Default is \code{"causal_forest"}. Note: you can also set model_type to NULL and specify custom_fit and custom_predict to use your custom model.}

\item{learner_type}{The learner type for the chosen model. Options include \code{"ridge"} for Ridge Regression, \code{"fnn"} for Feedforward Neural Network and \code{"caret"} for Caret. Default is \code{"ridge"}. if model_type is 'causal_forest', choose NULL, if model_type is 's_learner' or 'm_learner', choose between 'ridge', 'fnn' and 'caret'.}

\item{baseline_policy}{A list providing the baseline policy (binary 0 or 1) for each sample. If \code{NULL}, defaults to a list of zeros with the same length as the number of rows in \code{X}.}

\item{parallelize_batch}{Logical. Whether to parallelize batch processing (i.e. the cram method learns T policies, with T the number of batches. They are learned in parallel when parallelize_batch is TRUE vs. learned sequentially using the efficient data.table structure when parallelize_batch is FALSE, recommended for light weight training). Defaults to \code{FALSE}.}

\item{model_params}{A list of additional parameters to pass to the model, which can be any parameter defined in the model reference package. Defaults to \code{NULL}.}

\item{custom_fit}{A custom, user-defined, function that outputs a fitted model given training data (allows flexibility). Defaults to \code{NULL}.}

\item{custom_predict}{A custom, user-defined, function for making predictions given a fitted model and test data (allow flexibility). Defaults to \code{NULL}.}

\item{alpha}{Significance level for confidence intervals. Default is 0.05 (95\% confidence).}

\item{propensity}{The propensity score function for binary treatment indicator (D) (probability for each unit to receive treatment). Defaults to 0.5 (random assignment).}
}
\value{
A list containing:
\itemize{
  \item \code{raw_results}: A data frame summarizing key metrics with truncated decimals:
    \itemize{
      \item \code{Delta Estimate}: The estimated treatment effect (delta).
      \item \code{Delta Standard Error}: The standard error of the delta estimate.
      \item \code{Delta CI Lower}: The lower bound of the confidence interval for delta.
      \item \code{Delta CI Upper}: The upper bound of the confidence interval for delta.
      \item \code{Policy Value Estimate}: The estimated policy value.
      \item \code{Policy Value Standard Error}: The standard error of the policy value estimate.
      \item \code{Policy Value CI Lower}: The lower bound of the confidence interval for policy value.
      \item \code{Policy Value CI Upper}: The upper bound of the confidence interval for policy value.
      \item \code{Proportion Treated}: The proportion of individuals treated under the final policy.
    }
  \item \code{interactive_table}: An interactive table summarizing key metrics for detailed exploration.
  \item \code{final_policy_model}: The final fitted policy model based on \code{model_type} and \code{learner_type} or \code{custom_fit}.
}
}
\description{
This function performs the cram method (simultaneous policy learning and evaluation)
for binary policies on data including covariates (X), binary treatment indicator (D) and outcomes (Y).
}
\examples{
# Example data
X_data <- matrix(rnorm(100 * 5), nrow = 100, ncol = 5)
D_data <- as.integer(sample(c(0, 1), 100, replace = TRUE))
Y_data <- rnorm(100)
nb_batch <- 5

# Perform CRAM policy
result <- cram_policy(X = X_data,
                          D = D_data,
                          Y = Y_data,
                          batch = nb_batch)

# Access results
result$raw_results
result$interactive_table
result$final_policy_model
}
\seealso{
\code{\link[grf]{causal_forest}}, \code{\link[glmnet]{cv.glmnet}}, \code{\link[keras]{keras_model_sequential}}
}
