% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covdepGE_package.R
\docType{package}
\name{covdepGE-package}
\alias{covdepGE-package}
\alias{_PACKAGE}
\title{covdepGE: Covariate Dependent Graph Estimation}
\description{
A covariate-dependent approach to Gaussian graphical modeling as described in Dasgupta et al. (2022). Employs a novel weighted pseudo-likelihood approach to model the conditional dependence structure of data as a continuous function of an extraneous covariate. The main function, covdepGE::covdepGE(), estimates a graphical representation of the conditional dependence structure via a block mean-field variational approximation, while several auxiliary functions (inclusionCurve(), matViz(), and plot.covdepGE()) are included for visualizing the resulting estimates.
}
\references{
(1) Sutanoy Dasgupta, Peng Zhao, Prasenjit Ghosh, Debdeep Pati, and Bani
Mallick. An approximate Bayesian approach to covariate-dependent graphical
modeling. pages 1–59, 2022.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/JacobHelwig/covdepGE}
  \item Report bugs at \url{https://github.com/JacobHelwig/covdepGE/issues}
}

}
\author{
\strong{Maintainer}: Jacob Helwig \email{jacob.a.helwig@tamu.edu}

Authors:
\itemize{
  \item Sutanoy Dasgupta \email{sutanoy@stat.tamu.edu}
  \item Peng Zhao \email{pzhao@stat.tamu.edu}
  \item Bani Mallick \email{bmallick@stat.tamu.edu}
  \item Debdeep Pati \email{debdeep@stat.tamu.edu}
}

}
