% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colpair.R
\name{colpair_map}
\alias{colpair_map}
\title{Apply a function to all pairs of columns in a data frame}
\usage{
colpair_map(.data, .f, ..., .diagonal = NA)
}
\arguments{
\item{.data}{A data frame or data frame extension (e.g. a tibble).}

\item{.f}{A function.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.diagonal}{Value at which to set the diagonal (defaults to \code{NA}).}
}
\value{
A correlation data frame (\code{cor_df}).
}
\description{
\code{colpair_map()} transforms a data frame by applying a function to each pair
of its columns. The result is a correlation data frame (see
\code{\link{correlate}} for details).
}
\examples{
## Using `stats::cov` produces a covariance data frame.
colpair_map(mtcars, cov)

## Function to get the p-value from a t-test:
calc_p_value <- function(vec_a, vec_b) {
  t.test(vec_a, vec_b)$p.value
}

colpair_map(mtcars, calc_p_value)
}
