% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsyntax.r
\name{agg_label}
\alias{agg_label}
\title{Helper function for aggregate_rsyntax}
\usage{
agg_label(label, ...)
}
\arguments{
\item{label}{The rsyntax label. Needs to be an existing value in the annotation column (as specified when calling \code{\link{aggregate_rsyntax}})}

\item{...}{Specify the new aggregated columns in name-value pairs. The name is the name of the new column, and the value should be a function over a column in $tokens. 
For example:  subject = paste(token, collapse = ' ')  would create the column 'subject', of which the values are the concatenated tokens. See examples for more.}
}
\value{
Not relevant. Should only be used within \code{\link{aggregate_rsyntax}}
}
\description{
This function is used within the \code{\link{aggregate_rsyntax}} function to facilitate aggregating by specific labels.
}
\examples{
tc = tc_sotu_udpipe$copy()
tc$udpipe_clauses()

## count number of tokens in predicate
aggregate_rsyntax(tc, 'clause', txt=FALSE,
                  agg_label('predicate', n = length(token_id)))
}
