% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_clip.R
\name{construct_clip}
\alias{construct_clip}
\title{Construct to clipboard}
\usage{
construct_clip(
  x,
  ...,
  data = NULL,
  pipe = NULL,
  check = NULL,
  unicode_representation = c("ascii", "latin", "character", "unicode"),
  escape = FALSE,
  pedantic_encoding = FALSE,
  compare = compare_options(),
  one_liner = FALSE,
  template = getOption("constructive_opts_template"),
  classes = NULL
)
}
\arguments{
\item{x}{An object, for \code{construct_multi()} a named list or an environment.}

\item{...}{Constructive options built with the \verb{opts_*()} family of functions. See the "Constructive options"
section below.}

\item{data}{Named list or environment of objects we want to detect and mention by name (as opposed to
deparsing them further). Can also contain unnamed nested lists, environments, or
package names, in the latter case package exports and datasets will be considered.
In case of conflict, the last provided name is considered.}

\item{pipe}{Which pipe to use, either \code{"base"} or \code{"magrittr"}.
Defaults to \code{"base"} for R >= 4.2, otherwise to \code{"magrittr"}.}

\item{check}{Boolean. Whether to check if the created code reproduces the object
using \code{waldo::compare()}.}

\item{unicode_representation}{By default "ascii", which means only ASCII characters
(code point < 128) will be used to construct strings and variable names. This makes sure that
homoglyphs (different spaces and other identically displayed unicode characters)
are printed differently, and avoid possible unfortunate copy and paste
auto conversion issues. "latin" is more lax and uses all latin characters
(code point < 256). "character" shows all characters, but not emojis. Finally
"unicode" displays all characters and emojis, which is what \code{dput()} does.}

\item{escape}{Boolean. Whether to escape double quotes and backslashes. If \code{FALSE} we use
single quotes to surround strings (including variable and element names)
containing double quotes, and raw strings for strings that contain backslashes
and/or a combination of single and double quotes. Depending on
\code{unicode_representation} \code{escape = FALSE} cannot be applied on all strings.}

\item{pedantic_encoding}{Boolean. Whether to mark strings with the "unknown" encoding
rather than an explicit native encoding ("UTF-8" or "latin1") when it's
necessary to reproduce the binary representation exactly. This detail is
normally of very little significance. The reason why we're not pedantic by default is that
the constructed code might be different in the console and in snapshot
tests and reprexes due to the latter rounding some angles, and it would
be confusing for users.}

\item{compare}{Parameters passed to \code{waldo::compare()}, built with \code{compare_options()}.}

\item{one_liner}{Boolean. Whether to collapse the output to a single line of code.}

\item{template}{A list of constructive options built with \verb{opts_*()} functions,
they will be overriden by \code{...}. Use it to set a default
behavior for \code{{constructive}}.}

\item{classes}{A character vector of classes for which to use idiomatic
constructors when available, we can provide a package instead of all its
classes, in the "\{pkg\}" form, and we can use a minus sign (inside the quotes)
to exclude rather than include. By default we use idiomatic constructors
whenever possible. The special values \code{"*none*"} and \code{"*base*"} can be used
to restrict the idiomatic construction to the objects. See \code{construct_dput()}
and \code{construct_base()} for wrappers around this feature.}
}
\value{
An object of class 'constructive', invisibly. Called for side effects.
}
\description{
This is a simple wrapper for convenience, \code{construct_clip(x, ...)} is equivalent to
\code{print(construct(x, ...), print_mode = "clipboard")} (an idiom that you might
use to use the clipboard with other functions). For more flexible printing
options see \code{?constructive_print_mode}.
}
\examples{
\dontrun{
construct_clip(head(cars))
}
}
