% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{writeImportXsi}
\alias{writeImportXsi}
\title{writeImportXsi}
\usage{
writeImportXsi(items, bmatix = 1L, lconstraint = "none", file)
}
\arguments{
\item{items}{a list of item matrices}

\item{bmatix}{either the integer 1L for a unidimensional model, or
a matrix, items by dimensions with 1L representing that the item in on this
dimension, and a 0 otherwise.}

\item{lconstraint}{the identification constraint in use, one of "none", "items",
or "cases".}

\item{file}{a path and filename to write file to disk.
#' @return invisibly returns path of file written to disk)}
}
\description{
Writes a fixed width text file in the format required for the
ACER ConQuest command and argument \verb{import anchor_xsi}. Can also be used
for initial values, though caution should be used with the interpretation
of the argument \code{lconstraint} which should relate to the model of interest
ACER ConQuest

Currently only works with implicit variables. Explicit variables may be added
in the future.
}
\examples{
  myItem <- matrix(c(0, 0, 0, 0, 1, 1, 0, 1), ncol = 4, byrow = TRUE)
  myItems <- list(myItem, myItem)
  myItems[[2]][2, 2] <- -1 # make the second item delta equal to -1
  myResponses <- genResponses(abilities = rnorm(100), itemParams = myItems)
}
\seealso{
\code{\link[=simplef]{simplef()}}, \code{\link[=genResponses]{genResponses()}}, \code{browseVignettes("conquestr")}
}
