% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{cmanhattan}
\alias{cmanhattan}
\title{Calculate a Manhattan distance of a factor in a dataframe.}
\usage{
cmanhattan(
  dataset,
  formula,
  plot = TRUE,
  plot_title = "Manhattan Distance Between Groups"
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A factor which you want to calculate Manhattan distance.}

\item{plot}{If TRUE, show a plot of distances.}

\item{plot_title}{The title of plot.}
}
\value{
A matrix containing distances.
}
\description{
This function takes a dataframe and a factor in input, and returns a matrix with the Manhattan distances about it.
}
\details{
Calculate Manhattan distance
}
\examples{
# Example with iris dataset

cmanhattan(iris, ~Species, plot = TRUE, plot_title = "Manhattan Distance Between Groups")

# Example with mtcars dataset

cmanhattan(mtcars, ~am, plot = TRUE, plot_title = "Manhattan Distance Between Groups")

}
