% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{ccanberra}
\alias{ccanberra}
\title{Calculate the Canberra distance for each species.}
\usage{
ccanberra(
  dataset,
  formula,
  plot = TRUE,
  plot_title = "Canberra Distance Between Groups"
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A factor which you want to calculate the Canberra distances matrix.}

\item{plot}{Logical, if TRUE, a plot of Canberra distances matrix is displayed.}

\item{plot_title}{The title to be used for the plot if plot is TRUE.}
}
\value{
A matrix containing Canberra distances between each pair of groups and the plot.
}
\description{
This function takes a dataframe and a factor in input, and returns a matrix with the Canberra distances about it.
}
\examples{
# Example with the iris dataset

ccanberra(iris, ~Species, plot = TRUE, plot_title = "Canberra Distance Between Groups")

# Example with the mtcars dataset
ccanberra(mtcars, ~am, plot = TRUE, plot_title = "Canberra Distance Between Groups")

}
