% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numberOfStatements.R
\name{numberOfStatements}
\alias{numberOfStatements}
\title{Count the Number of Statements in Concept Map Data}
\usage{
numberOfStatements(CMData, verbose = TRUE)
}
\arguments{
\item{CMData}{A data frame containing concept map data. This must include a column named \code{"statement"}.}

\item{verbose}{A logical, if \code{TRUE}, the function will print the number of statements the console.}
}
\value{
An integer representing the number of unique statements in the dataset.
}
\description{
This function calculates the number of unique statements in a given concept mapping dataset.
}
\details{
The function first checks if the provided dataset is suitable for concept mapping using the \cr
\code{checkConceptMapData} function. If the data is valid, it calculates and returns the number
of unique \code{statement}s.
}
\examples{
# Example of valid data
CMData <- data.frame(
  sorterID = c("resp1", "resp1", "resp1", "resp2",
   "resp2", "resp2", "resp3", "resp3", "resp3"),
  statement = c("London", "Frankfurt", "Berlin", "London",
   "Frankfurt", "Berlin", "London", "Frankfurt", "Berlin"),
  stackID = c("capital city", "city", "capital city", 1, 2, 2, "A", "B", "A")
)

# Count the number of statements silently
numberOfStatements(CMData, verbose = FALSE)

# Count the number of statements with message
numberOfStatements(CMData)

}
