% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadDataADaMSDTM.R
\name{loadDataADaMSDTM}
\alias{loadDataADaMSDTM}
\title{Load data from ADaM/SDTM file(s).}
\usage{
loadDataADaMSDTM(
  files,
  data,
  convertToDate = FALSE,
  dateVars = "DTC$",
  verbose = TRUE,
  encoding = "UTF-8",
  ...
)
}
\arguments{
\item{files}{Character vector with path to ADaM or SDTM file(s).\cr
Currently only import of files with extension: 'sas7bdat' or 'xpt' are supported.}

\item{data}{Named list with \link{raw} vector data 
(as supported by: \link[haven]{read_sas} and \link[haven]{read_xpt}).\cr
The list should be named with the file name (or full path)
the data has been imported from (e.g.: 'ae.xpt' or '/path/to/data.adsl.sas7bdat').}

\item{convertToDate}{logical, if TRUE columns with date/time are converted to 
\code{\link{POSIXct}} format, which stores calendar date/time in R.
Please note that most of the time this is not necessary, as date variables
are automatically imported via the \code{haven} package if encoded correctly in the dataset.}

\item{dateVars}{vector of columns in \code{data} containing date/time,
or pattern for this columns.
By default all columns ending with 'DTC' are used (dateVars is: 'DTC$').}

\item{verbose}{logical, if TRUE (by default) progress messages are printed during execution.}

\item{encoding}{String with encoding, only used if \code{files} is of extension: 'sas7bdat',
'UTF-8' by default.}

\item{...}{Additional parameters for the \code{\link[haven]{read_sas}} or
\code{\link[haven]{read_xpt}} functions, depending on the input file type.}
}
\value{
List of data.frame with data of each ADAM file (if not empty),
with special attributes:
\itemize{
 \item 'labelVars': named vector with label of the variables
 \item 'label': named vector with label of the datasets
}
Each data.frame contains an additional column called 'dataset' 
specifying the name of the \code{files} it was read from.
}
\description{
Load data set in SAS format ('sas7bdat' or 'xpt') into R data.frames, from
\code{files} or raw vector \code{data}.
}
\details{
While creating the R data.frames, if date/time variables are present, 
those are converted into to R date/time class 
(see \code{\link{convertToDateTime}}) function.

The labels of the ADaM/SDTM data sets are attached as attributes 
of the R data.frame.
}
\examples{
\dontrun{
dataFromSAS7bdat <- loadDataADaMSDTM(files = "ae.sas7bdat")
attr(dataFromSAS7bdat, "labelVars") # column labels
dataFromXpt <- loadDataADaMSDTM(files = c("ae.xpt", "dm.xpt"))
attr(dataFromXpt, "labelVars") # column labels
}
}
\author{
Laure Cougnaud
}
