% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_and_remove_duplicates.R
\name{find_duplicates}
\alias{find_duplicates}
\title{Identify and return duplicated rows in a data frame or linelist.}
\usage{
find_duplicates(data, target_columns = NULL)
}
\arguments{
\item{data}{The input \code{<data.frame>} or \code{<linelist>}.}

\item{target_columns}{A \code{<vector>} of columns names or indices to
consider when looking for duplicates. When the input data is a
\code{<linelist>} object, this parameter can be set to
\code{linelist_tags} from which duplicates to be removed. Its default
value is \code{NULL}, which considers duplicates across all columns.}
}
\value{
A \code{<data.frame>} or \code{<linelist>} of all duplicated rows
with following 2 additional columns:
\describe{
\item{row_id}{The indices of the duplicated rows from the input data.
Users can choose from these indices, which row they consider as
redundant in each group of duplicates.}
\item{group_id}{a unique identifier associated to each group of
duplicates.}
}
}
\description{
Identify and return duplicated rows in a data frame or linelist.
}
\examples{
data <- readRDS(
  system.file("extdata", "test_linelist.RDS", package = "cleanepi")
)

# find duplicates across the following columns: "dt_onset", "dt_report",
# "sex", and "outcome"
dups <- find_duplicates(
  data = data,
  target_columns = c("dt_onset", "dt_report", "sex", "outcome")
)

# print the detected duplicates
print_report(dups, "found_duplicates")

}
