% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{models_get_builds}
\alias{models_get_builds}
\title{Check status of a build}
\usage{
models_get_builds(id, build_id)
}
\arguments{
\item{id}{integer required. The ID of the model.}

\item{build_id}{integer required. The ID of the build.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the model build.}
\item{state}{string, The state of the model build.one of 'queued' 'running' 'succeeded' 'failed' or 'cancelled'.}
\item{error}{string, The error, if any, returned by the build.}
\item{name}{string, The name of the model build.}
\item{createdAt}{string, The time the model build was created.}
\item{description}{string, A description of the model build.}
\item{rootMeanSquaredError}{number, A key metric for continuous models. Nil for other model types.}
\item{rSquaredError}{number, A key metric for continuous models. Nil for other model types.}
\item{rocAuc}{number, A key metric for binary, multinomial, and ordinal models. Nil for other model types.}
\item{transformationMetadata}{string, A string representing the full JSON output of the metadata for transformation of column names}
\item{output}{string, A string representing the JSON output for the specified build. Only present when smaller than 10KB in size.}
\item{outputLocation}{string, A URL representing the location of the full JSON output for the specified build.The URL link will be valid for 5 minutes.}
}
\description{
Check status of a build
}
