% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chronochrt_wrapper_import.R
\name{import_chron}
\alias{import_chron}
\title{Import data for Chronological chart}
\usage{
import_chron(
  path,
  region = "region",
  name = "name",
  start = "start",
  end = "end",
  level = "level",
  add = "add",
  delim,
  ...
)
}
\arguments{
\item{path}{A character string with either the path or a URL to the file to
be imported.}

\item{region}{Character string (case sensitive) with the column name of the
region/section, default to \code{"region"}.}

\item{name}{Character string (case sensitive) with the column name of the
chronological units' names, default to \code{"name"}.}

\item{start}{Character string (case sensitive) with the column name of the
chronological units' start dates, default to \code{"start"}.}

\item{end}{Character string (case sensitive) with the column name of the
chronological units' end dates, default to \code{"end"}.}

\item{level}{Character string (case sensitive) with the column name of the
chronological units' levels, default to \code{"level"}.}

\item{add}{Character string (case sensitive) with the column name of the
information whether the chronological units within a region/section should
be drawn separately or not, default to \code{"add"}.}

\item{delim}{A character string with the separator for tabular data. Use
\code{delim = "\t"} for tab-separated data. Must be provided for all file
types except \code{.xlsx} or \code{.xls}.}

\item{...}{Additional arguments passed to the respective import functions.
See their documentation for details: \itemize{ \item
\code{\link[readxl]{read_excel}} for file formats \code{.xlsx} and
\code{.xls}, \item \code{\link[readr]{read_csv}} for the file format
\code{.csv}, \item \code{\link[readr]{read_delim}} for all other file
formats. }}
}
\value{
A tibble containing the desired chronological information.
}
\description{
The function imports and converts chronological information from tabular data
saved as \code{.csv}, \code{.xlsx} and \code{.xls}, and any other kind of
delimited file format into a ready-to-use data set for plotting with
ChronochRt. It automatically selects the appropriate import function from the
file extension and the argument \code{delim}. To import excel files, the
package \pkg{readxl} must be installed.
}
\details{
Additional columns in the import file will be imported as they are. Among
these might be e.g. columns specifying the x and y position of the names to
place them at an arbitrary spot.
}
\examples{
\dontrun{

# Import of Excel files
chrons <- import_chron(path = "ex_urnfield_periods.xlsx",
                       region = "Region",
                       name = "Name",
                       start = "Start",
                       end = "End",
                       level = "Level",
                       add = "Add")

# Import of delimited tabular data
chrons <- import_chron(path = "ex_urnfield_periods.csv",
                       region = "Region",
                       name = "Name",
                       start = "Start",
                       end = "End",
                       add = "Add",
                       delim = ",")

chrons <- import_chron(path = "ex_urnfield_periods.txt",
                       region = "Region",
                       name = "Name",
                       start = "Start",
                       end = "End",
                       add = "Add",
                       delim = "\t")

# Include additional parameters of the import function
chrons <- import_chron(path = "ex_urnfield_periods.xlsx",
                       region = "Region",
                       name = "Name",
                       start = "Start",
                       end = "End",
                       level = "Level",
                       add = "Add",
                       sheet = "data")
}
}
