test_that("distributions have good output", {
  normString = causact::normal(0,10)
  expect_equal(normString, "dist.Normal(0,10)")
  expString = causact::exponential(7)
  expect_equal(expString, "dist.Exponential(7)")
  uniformString = causact::uniform(0,8)
  expect_equal(uniformString, "dist.Uniform(0,8)")
  studentString = causact::student(df=3,mu=8,sigma=7)
  expect_equal(studentString, "dist.StudentT(3,8,7)")
  poissonString = causact::poisson(lambda = 9)
  expect_equal(poissonString, "dist.Poisson(9)")
  logNorm = causact::lognormal(meanlog = 9, 10)
  expect_equal(logNorm, "dist.LogNormal(9,10)")
  binomStr = causact::binomial("numTrials","succProb")
  expect_equal(binomStr, "dist.Binomial(numTrials,succProb)")
  expect_equal(bernoulli(0.5), "dist.Bernoulli(0.5)")
  expect_equal(negative_binomial(10, 0.5), "dist.NegativeBinomial(10,0.5)")
  expect_equal(gamma(1,2), "dist.Gamma(1,2)")
  expect_equal(inverse_gamma(1,2), "dist.InverseGamma(1,2)")
  expect_equal(weibull(3,4), "dist.Weibull(4,1/3)")
  expect_equal(cauchy(1,2), "dist.Cauchy(1,2)")
})

