% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_render.R
\name{dag_render}
\alias{dag_render}
\title{Render the graph as an htmlwidget}
\usage{
dag_render(
  graph,
  shortLabel = FALSE,
  wrapWidth = 24,
  width = NULL,
  height = NULL,
  fillColor = "aliceblue",
  fillColorObs = "cadetblue"
)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph}.}

\item{shortLabel}{a logical value.  If set to \code{TRUE}, distribution and formula information is suppressed.  Meant for communication with non-statistical stakeholders.}

\item{wrapWidth}{a numeric value.  Used to restrict width of nodes.  Default is wrap text after 24 characters.}

\item{width}{a numeric value.  an optional parameter for specifying the width of the resulting graphic in pixels.}

\item{height}{a numeric value.  an optional parameter for specifying the height of the resulting graphic in pixels.}

\item{fillColor}{a valid R color to be used as the default node fill color during \code{dag_render()}.}

\item{fillColorObs}{a valid R color to be used as the fill color for observed nodes during \code{dag_render()}.}
}
\value{
Returns an object of class \code{grViz} and \code{htmlwidget} that is also rendered in the RStudio viewer for interactive buidling of graphical models.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Using a \code{causact_graph} object, render the graph in the RStudio Viewer.
}
\examples{
# Render a simple graph
dag_create() \%>\%
  dag_node("Demand","X") \%>\%
  dag_node("Price","Y", child = "X") \%>\%
  dag_render()

# Hide the mathematical details of a graph
dag_create() \%>\%
  dag_node("Demand","X") \%>\%
  dag_node("Price","Y", child = "X") \%>\%
  dag_render(shortLabel = TRUE)
}
