\name{expanded_tree_from_jplace}
\alias{expanded_tree_from_jplace}
\title{
Place queries on a tree from a jplace file.
}
\description{
Given a \code{jplace} file (e.g., as generated by \code{pplacer} or \code{EPA-NG}), construct an expanded tree consisting of the original reference tree and additional tips representing the placed query sequences. The reference tree and placements are loaded from the jplace file. If multiple placements are listed for a query, this function can either add the best (maximum-likelihood) placement or all listed placements.
}
\usage{
expanded_tree_from_jplace(file_path,
                          only_best_placements  = TRUE,
                          max_names_per_query   = 1)
}
\arguments{
\item{file_path}{
Character, the path to the input \code{jplace} file.
}
\item{only_best_placements}{
Logical, only keep the best placement of each query, i.e., the placement with maximum likelihood.
}
\item{max_names_per_query}{
Positive integer, maximum number of sequence names to keep from each query. Only relevant if queries in the jplace file include multiple sequence names (these typically represent identical sequences). If greater than 1, and a query includes multiple sequence names, then each of these sequence names will be added as a tip to the tree.
}
}
\details{
This function assumes version 3 of the jplace file format, as defined by Matsen et al. (2012).
}
\value{
A named list with the following elements:
\item{tree}{
Object of class "phylo", the extended tree constructed by adding the placements on the reference tree.
}
\item{placed_tips}{
Integer vector, specifying which tips in the returned tree correspond to placements.
}
\item{reference_tree}{
Object of class "phylo", the original reference tree loaded from the jplace file. This will be a subtree of \code{tree}.
}
}


\author{Stilianos Louca}

\references{
Frederick A. Matsen et al. (2012). A format for  phylogenetic placements. PLOS One. 7:e31009
}

\seealso{
\code{\link{place_tips_taxonomically}}
}

\examples{
\dontrun{
# load jplace file and create expanded tree
J = expanded_tree_from_jplace("epa_ng_output.jplace")

# save the reference and expanded tree as Newick files
write_tree(J$reference_tree, file="reference.tre")
write_tree(J$tree, file="expanded.tre")
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{placement}
