% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdm_as.R
\name{sdm_as_stars}
\alias{sdm_as_stars}
\alias{sdm_as_raster}
\alias{sdm_as_terra}
\title{\code{sdm_as_X} functions to transform \code{caretSDM} data into other classes.}
\usage{
sdm_as_stars(x,
             what = NULL,
             spp = NULL,
             scen = NULL,
             id = NULL,
             ens = NULL)

sdm_as_raster(x, what = NULL, spp = NULL, scen = NULL, id = NULL, ens = NULL)

sdm_as_terra(x, what = NULL, spp = NULL, scen = NULL, id = NULL, ens = NULL)
}
\arguments{
\item{x}{A \code{caretSDM} object.}

\item{what}{Sometimes multiple data inside \code{x} could be transformed. This parameter allows
users to specify what needs to be converted.It can be one of: "predictors", "scenarios",
"predictions" or "ensembles".}

\item{spp}{\code{character}. Which species should be converted?}

\item{scen}{\code{character}. Which scenario should be converted?}

\item{id}{\code{character}. Which id should be converted?}

\item{ens}{\code{character}. Which ensemble should be converted?}
}
\value{
The output is the desired class.
}
\description{
This functions transform data from a \code{caretSDM} object to be used in other packages.
}
\examples{
# Create sdm_area object:
sa <- sdm_area(parana, cell_size = 100000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio12"))

# Include scenarios:
sa <- add_scenarios(sa)

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Pseudoabsence generation:
i <- pseudoabsences(i, method="random", n_set=2)

# Custom trainControl:
ctrl_sdm <- caret::trainControl(method = "boot",
                                number = 1,
                                classProbs = TRUE,
                                returnResamp = "all",
                                summaryFunction = summary_sdm,
                                savePredictions = "all")

# Train models:
i <- train_sdm(i, algo = c("naive_bayes"), ctrl=ctrl_sdm) |>
  suppressWarnings()

# Predict models:
i  <- predict_sdm(i, th=0.8)

# Transform in stars:
sdm_as_stars(i)

}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
