% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{select_predictors}
\alias{select_predictors}
\alias{select.sdm_area}
\alias{select.input_sdm}
\alias{mutate.sdm_area}
\alias{mutate.input_sdm}
\alias{filter.sdm_area}
\alias{filter.input_sdm}
\alias{filter.occurrences}
\alias{filter_species}
\title{Tidyverse methods for caretSDM objects}
\usage{
select_predictors(x, ...)

\method{select}{sdm_area}(.data, ...)

\method{select}{input_sdm}(.data, ...)

\method{mutate}{sdm_area}(.data, ...)

\method{mutate}{input_sdm}(.data, ...)

\method{filter}{sdm_area}(.data, ..., .by, .preserve)

\method{filter}{input_sdm}(.data, ..., .by, .preserve)

\method{filter}{occurrences}(.data, ..., .by, .preserve)

filter_species(x, spp = NULL, ...)
}
\arguments{
\item{x}{\code{sdm_area} or \code{input_sdm} object.}

\item{...}{\code{character} arguments to pass to the given function.}

\item{.data}{Data to pass to tidyr function.}

\item{.by}{See ?dplyr::filter.}

\item{.preserve}{See ?dplyr::filter.}

\item{spp}{Species to be filtered.}
}
\value{
The transformed \code{sdm_area}/\code{input_sdm} object.
}
\description{
Set of functions to facilitate the use of caretSDM through tidyverse grammatics.
}
\examples{
# Create sdm_area object:
sa <- sdm_area(parana, cell_size = 25000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio4", "bio12"))

}
