% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{two_curvy_diff_pts}
\alias{two_curvy_diff_pts}
\title{Generate Two Curvilinear Differentiated Clusters with Noise}
\usage{
two_curvy_diff_pts(cluster_size_vec, num_noise, min_n, max_n)
}
\arguments{
\item{cluster_size_vec}{A vector specifying the number of points in each cluster.}

\item{num_noise}{The number of additional noise dimensions to be generated.}

\item{min_n}{The minimum value for the noise added to the data points.}

\item{max_n}{The maximum value for the noise added to the data points.}
}
\value{
A matrix containing the generated data, with each row representing a data point.
}
\description{
This function generates data with two curvilinear clusters that are differentiated
from each other, along with added noise.
}
\examples{

# Generate two curvilinear differentiated clusters with noise with custom parameters
set.seed(20240412)
data <- two_curvy_diff_pts(
  cluster_size_vec = c(50, 100), num_noise = 2,
  min_n = -0.05, max_n = 0.05
)
}
