% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{three_clust_diff_dist}
\alias{three_clust_diff_dist}
\title{Generate three clusters of data points with optional noise.}
\usage{
three_clust_diff_dist(n, num_dims, num_noise, min_n, max_n)
}
\arguments{
\item{n}{Total number of data points to generate, should be a multiple of three.}

\item{num_dims}{Number of dimensions for each data point.}

\item{num_noise}{Number of additional noise dimensions to add to the data.}

\item{min_n}{Minimum value for the noise added to the data.}

\item{max_n}{Maximum value for the noise added to the data.}
}
\value{
A matrix containing the generated data points with or without added noise.
}
\description{
This function generates three clusters of data points along with optional noise.
}
\examples{
set.seed(20240412)
three_clust_diff_dist(
  n = 150, num_dims = 7, num_noise = 4, min_n = -0.05,
  max_n = 0.05
)

}
