% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{gen_bkg_noise}
\alias{gen_bkg_noise}
\title{Generate Background Noise Data}
\usage{
gen_bkg_noise(n, num_dims, mean, sd)
}
\arguments{
\item{n}{Number of samples to generate.}

\item{num_dims}{Number of dimensions (columns) of the data.}

\item{mean}{Mean of the normal distribution used to generate noise (default is 0).}

\item{sd}{Standard deviation of the normal distribution used to generate noise (default is 1).}
}
\value{
A matrix containing the generated background noise data, with
\code{n} rows and \code{num_dims} columns.
}
\description{
This function generates background noise data with specified parameters such as
the number of samples, number of dimensions, mean, and standard deviation.
}
\examples{

# Generate background noise with custom mean and standard deviation
set.seed(20240412)
gen_bkg_noise(n = 50, num_dims = 3, mean = 5, sd = 2)

}
