% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.R
\name{four_long_clust}
\alias{four_long_clust}
\title{Generate Four Different Long Clusters with Noise}
\usage{
four_long_clust(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the four different long clusters with added noise.
}
\description{
This function generates a dataset consisting of four different long clusters
with added noise.
}
\examples{
set.seed(20240412)
four_diff_long_clusters <- four_long_clust(
  n = 200, num_noise = 2,
  min_n = -0.05, max_n = 0.05
)
}
